<?php
require_once '../includes/config.php';

if (!isset($_GET['token'])) {
    die("Token tidak valid");
}

$token = $_GET['token'];
$current_time = date('Y-m-d H:i:s');

// Check token validity
$stmt = $pdo->prepare("SELECT * FROM student_tokens 
                      WHERE token = ? AND valid_until > ? AND used = FALSE");
$stmt->execute([$token, $current_time]);
$token_data = $stmt->fetch();

if (!$token_data) {
    die("Token tidak valid atau sudah kadaluarsa");
}

// Get exam data
$stmt = $pdo->prepare("SELECT * FROM exams WHERE id = ?");
$stmt->execute([$token_data['exam_id']]);
$exam = $stmt->fetch();

if (!$exam) {
    die("Ujian tidak ditemukan");
}

// Get questions
$stmt = $pdo->prepare("SELECT * FROM questions WHERE exam_id = ? ORDER BY id");
$stmt->execute([$exam['id']]);
$questions = $stmt->fetchAll();

// Mark token as used to prevent multiple submissions
$stmt = $pdo->prepare("UPDATE student_tokens SET used = TRUE WHERE id = ?");
$stmt->execute([$token_data['id']]);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Process answers
    foreach ($questions as $question) {
        $answer = $_POST['answers'][$question['id']] ?? '';
        
        $stmt = $pdo->prepare("INSERT INTO student_answers 
                              (token_id, question_id, answer) 
                              VALUES (?, ?, ?)");
        $stmt->execute([$token_data['id'], $question['id'], $answer]);
    }
    
    // Redirect to thank you page
    header("Location: submit.php?token=" . $token);
    exit();
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ujian - <?php echo htmlspecialchars($exam['title']); ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <div class="container">
        <div class="exam-header">
            <h1><?php echo htmlspecialchars($exam['title']); ?></h1>
            <p><?php echo htmlspecialchars($exam['description']); ?></p>
            <p>Nama Siswa: <strong><?php echo htmlspecialchars($token_data['student_name']); ?></strong></p>
        </div>
        
        <form method="POST">
            <?php foreach ($questions as $index => $question): ?>
                <div class="exam-question">
                    <div class="question-text">
                        <p><?php echo ($index + 1) . '. ' . htmlspecialchars($question['question_text']); ?></p>
                    </div>
                    
                    <?php if ($question['question_type'] == 'multiple_choice'): ?>
                        <div class="question-options">
                            <?php 
                            $options = json_decode($question['options'], true);
                            foreach ($options as $i => $option): 
                            ?>
                                <div class="option">
                                    <label>
                                        <input type="radio" name="answers[<?php echo $question['id']; ?>]" value="<?php echo $i; ?>" required>
                                        <?php echo htmlspecialchars($option); ?>
                                    </label>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php else: ?>
                        <div class="question-essay">
                            <textarea name="answers[<?php echo $question['id']; ?>]" rows="4" required></textarea>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
            
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">Kirim Jawaban</button>
            </div>
        </form>
    </div>
</body>
</html>