<?php
require_once '../includes/config.php';

if (!isset($_GET['token'])) {
    redirect('../index.php');
}

$token = $_GET['token'];
$stmt = $pdo->prepare("SELECT st.*, e.title as exam_title 
                      FROM student_tokens st
                      JOIN exams e ON e.id = st.exam_id
                      WHERE st.token = ?");
$stmt->execute([$token]);
$submission = $stmt->fetch();

if (!$submission) {
    redirect('../index.php');
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ujian Selesai - Sistem Ujian SD</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <div class="container">
        <div class="submit-container">
            <h1>Terima Kasih!</h1>
            <h2>Ujian: <?php echo htmlspecialchars($submission['exam_title']); ?></h2>
            <p>Nama Siswa: <?php echo htmlspecialchars($submission['student_name']); ?></p>
            <p>Jawaban Anda telah berhasil dikumpulkan.</p>
            
            <div class="submit-info">
                <p>Anda dapat menutup halaman ini sekarang.</p>
                <p>Guru akan memeriksa jawaban Anda dan memberikan nilai.</p>
            </div>
        </div>
    </div>
</body>
</html>