<?php
require_once '../includes/config.php';
require_once '../includes/auth.php';

// Only teachers can access this page
if ($_SESSION['role'] !== 'teacher') {
    redirect('../index.php');
}

$subjects = [];
if ($_SESSION['grade_level'] == '1-2') {
    $subjects = ['Mtk', 'B.indo', 'PPKn', 'B.inggris', 'Science', 'Math', 'TIK', 
                'Agama Islam', 'Agama Kristen', 'Agama Katolik', 'Agama Hindu', 
                'Agama Budha', 'Agama Konghucu', 'PJOK', 'PLBJ', 'SBDP', 'Praktik Ibadah'];
} else {
    $subjects = ['Mtk', 'B.indo', 'PPKn', 'IPAS', 'B.inggris', 'Science', 'Math', 'TIK', 
                'Agama Islam', 'Agama Kristen', 'Agama Katolik', 'Agama Hindu', 
                'Agama Budha', 'Agama Konghucu', 'PJOK', 'PLBJ', 'SBDP', 'Praktik Ibadah'];
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = $_POST['title'];
    $subject = $_POST['subject'];
    $description = $_POST['description'];
    
    // Create exam
    $stmt = $pdo->prepare("INSERT INTO exams (teacher_id, title, subject, grade_level, description) 
                          VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([$_SESSION['user_id'], $title, $subject, $_SESSION['grade_level'], $description]);
    $exam_id = $pdo->lastInsertId();
    
    // Process questions
    foreach ($_POST['questions'] as $question) {
        $question_text = $question['text'];
        $question_type = $question['type'];
        $options = null;
        $correct_answer = null;
        
        if ($question_type == 'multiple_choice') {
            $options = json_encode($question['options']);
            $correct_answer = $question['correct_answer'];
        }
        
        $stmt = $pdo->prepare("INSERT INTO questions 
                              (exam_id, question_type, question_text, options, correct_answer, max_score) 
                              VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([$exam_id, $question_type, $question_text, $options, $correct_answer, $question['max_score']]);
    }
    
    $_SESSION['success'] = "Ujian berhasil dibuat!";
    redirect("preview_exam.php?id=$exam_id");
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Buat Ujian - Sistem Ujian SD</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <?php include '../includes/header.php'; ?>
    
    <div class="container">
        <h1>Buat Ujian Baru</h1>
        
        <form id="examForm" method="POST" enctype="multipart/form-data">
            <div class="form-group">
                <label for="title">Judul Ujian*</label>
                <input type="text" id="title" name="title" required>
            </div>
            
            <div class="form-group">
                <label for="subject">Mata Pelajaran*</label>
                <select id="subject" name="subject" required>
                    <?php foreach ($subjects as $subject): ?>
                        <option value="<?php echo $subject; ?>"><?php echo $subject; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div class="form-group">
                <label for="description">Deskripsi Ujian</label>
                <textarea id="description" name="description" rows="3"></textarea>
            </div>
            
            <div id="questionsContainer">
                <!-- Questions will be added here -->
            </div>
            
            <div class="form-actions">
                <button type="button" id="addQuestionBtn" class="btn btn-secondary">Tambah Pertanyaan</button>
                <button type="submit" class="btn btn-primary">Simpan Ujian</button>
            </div>
        </form>
    </div>
    
    <script src="../assets/js/script.js"></script>
</body>
</html>