<?php
require_once '../includes/config.php';
require_once '../includes/auth.php';

if ($_SESSION['role'] !== 'teacher') {
    redirect('../index.php');
}

// Get teacher's exams
$stmt = $pdo->prepare("SELECT e.*, 
                      COUNT(st.id) as submission_count,
                      COUNT(DISTINCT q.id) as question_count
                      FROM exams e
                      LEFT JOIN student_tokens st ON st.exam_id = e.id
                      LEFT JOIN questions q ON q.exam_id = e.id
                      WHERE e.teacher_id = ?
                      GROUP BY e.id
                      ORDER BY e.created_at DESC");
$stmt->execute([$_SESSION['user_id']]);
$exams = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Guru - Sistem Ujian SD</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <?php include '../includes/header.php'; ?>
    
    <div class="container">
        <h1>Dashboard Guru</h1>
        <p>Mata Pelajaran: <?php echo $_SESSION['subject']; ?> | Kelas: <?php echo $_SESSION['grade_level']; ?></p>
        
        <div class="actions">
            <a href="create_exam.php" class="btn btn-primary">Buat Ujian Baru</a>
        </div>
        
        <h2>Daftar Ujian</h2>
        
        <?php if (empty($exams)): ?>
            <p>Anda belum membuat ujian apapun.</p>
        <?php else: ?>
            <div class="exams-grid">
                <?php foreach ($exams as $exam): ?>
                <div class="exam-card">
                    <h3><?php echo htmlspecialchars($exam['title']); ?></h3>
                    <p><?php echo htmlspecialchars($exam['subject']); ?> - Kelas <?php echo htmlspecialchars($exam['grade_level']); ?></p>
                    <p>Jumlah Soal: <?php echo $exam['question_count']; ?></p>
                    <p>Jumlah Pengumpulan: <?php echo $exam['submission_count']; ?></p>
                    <div class="exam-actions">
                        <a href="preview_exam.php?id=<?php echo $exam['id']; ?>" class="btn btn-sm btn-secondary">Pratinjau</a>
                        <a href="view_results.php?id=<?php echo $exam['id']; ?>" class="btn btn-sm btn-primary">Hasil</a>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>