<?php
require_once '../includes/config.php';
require_once '../includes/auth.php';

if ($_SESSION['role'] !== 'teacher') {
    redirect('../index.php');
}

if (!isset($_GET['id'])) {
    redirect('dashboard.php');
}

$exam_id = $_GET['id'];
$stmt = $pdo->prepare("SELECT * FROM exams WHERE id = ? AND teacher_id = ?");
$stmt->execute([$exam_id, $_SESSION['user_id']]);
$exam = $stmt->fetch();

if (!$exam) {
    redirect('dashboard.php');
}

$stmt = $pdo->prepare("SELECT * FROM questions WHERE exam_id = ?");
$stmt->execute([$exam_id]);
$questions = $stmt->fetchAll();

if (isset($_SESSION['success'])) {
    $success = $_SESSION['success'];
    unset($_SESSION['success']);
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pratinjau Ujian - Sistem Ujian SD</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <?php include '../includes/header.php'; ?>
    
    <div class="container">
        <?php if (isset($success)): ?>
            <div class="alert alert-success"><?php echo $success; ?></div>
        <?php endif; ?>
        
        <div class="exam-preview">
            <h2><?php echo htmlspecialchars($exam['title']); ?></h2>
            <p class="description"><?php echo nl2br(htmlspecialchars($exam['description'])); ?></p>
            
            <div class="questions">
                <?php foreach ($questions as $index => $question): ?>
                    <div class="preview-question">
                        <div class="question-text">
                            <?php echo ($index + 1) . '. ' . htmlspecialchars($question['question_text']); ?>
                        </div>
                        
                        <?php if ($question['question_type'] == 'multiple_choice'): ?>
                            <div class="options">
                                <?php 
                                $options = json_decode($question['options'], true);
                                foreach ($options as $i => $option): 
                                ?>
                                    <div class="option">
                                        <input type="radio" disabled>
                                        <?php echo htmlspecialchars($option); ?>
                                        <?php if ($i == $question['correct_answer']): ?>
                                            <span style="color: green; margin-left: 10px;">(Jawaban Benar)</span>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php else: ?>
                            <div class="essay-answer">
                                <textarea rows="3" style="width: 100%;" disabled placeholder="Jawaban essay"></textarea>
                            </div>
                        <?php endif; ?>
                        
                        <div class="question-meta">
                            <small>Tipe: <?php echo $question['question_type'] == 'multiple_choice' ? 'Pilihan Ganda' : 'Essay'; ?></small>
                            <small style="margin-left: 10px;">Nilai Maks: <?php echo $question['max_score']; ?></small>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        
        <div class="share-exam">
            <h3>Bagikan Ujian</h3>
            <div class="form-group">
                <label for="examLink">Link Ujian:</label>
                <input type="text" id="examLink" class="form-control" readonly 
                       placeholder="Klik tombol Generate untuk membuat link">
            </div>
            
            <div class="alert alert-info" id="tokenInfo">
                Belum ada token yang dibuat
            </div>
            
            <button type="button" id="generateTokenBtn" class="btn btn-primary"
                    data-exam-id="<?php echo $exam_id; ?>">
                <i class="fas fa-link"></i> Generate Link Ujian
            </button>
            
            <div class="mt-3">
                <small class="text-muted">
                    Link akan berlaku selama 10 menit setelah digenerate
                </small>
            </div>
        </div>
    </div>

    <!-- Fixed: Path script yang benar -->
    <script src="../assets/js/script.js"></script>
</body>
</html>