  <?php
require_once '../includes/config.php';
require_once '../includes/auth.php';

if ($_SESSION['role'] !== 'teacher') {
    redirect('../index.php');
}

if (!isset($_GET['id'])) {
    redirect('dashboard.php');
}

$exam_id = $_GET['id'];
$stmt = $pdo->prepare("SELECT * FROM exams WHERE id = ? AND teacher_id = ?");
$stmt->execute([$exam_id, $_SESSION['user_id']]);
$exam = $stmt->fetch();

if (!$exam) {
    redirect('dashboard.php');
}

// Get all submissions for this exam
$stmt = $pdo->prepare("SELECT st.id, st.student_name, st.valid_until, 
                      COUNT(sa.id) as answer_count,
                      SUM(CASE WHEN sa.graded = TRUE THEN sa.score ELSE 0 END) as total_score
                      FROM student_tokens st
                      LEFT JOIN student_answers sa ON sa.token_id = st.id
                      WHERE st.exam_id = ?
                      GROUP BY st.id");
$stmt->execute([$exam_id]);
$submissions = $stmt->fetchAll();

// Get all questions for this exam to calculate max score
$stmt = $pdo->prepare("SELECT SUM(max_score) as max_score FROM questions WHERE exam_id = ?");
$stmt->execute([$exam_id]);
$max_score = $stmt->fetchColumn();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hasil Ujian - Sistem Ujian SD</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <?php include '../includes/header.php'; ?>
    
    <div class="container">
        <h1>Hasil Ujian: <?php echo htmlspecialchars($exam['title']); ?></h1>
        <p>Mata Pelajaran: <?php echo htmlspecialchars($exam['subject']); ?></p>
        <p>Kelas: <?php echo htmlspecialchars($exam['grade_level']); ?></p>
        
        <div class="results-summary">
            <h3>Ringkasan Hasil</h3>
            <p>Jumlah Peserta: <?php echo count($submissions); ?></p>
            <p>Nilai Maksimal: <?php echo $max_score; ?></p>
        </div>
        
        <table class="results-table">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Nama Siswa</th>
                    <th>Waktu Pengumpulan</th>
                    <th>Jumlah Jawaban</th>
                    <th>Total Nilai</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($submissions as $index => $submission): ?>
                    <tr>
                        <td><?php echo $index + 1; ?></td>
                        <td><?php echo htmlspecialchars($submission['student_name']); ?></td>
                        <td><?php echo date('d/m/Y H:i', strtotime($submission['valid_until'])); ?></td>
                        <td><?php echo $submission['answer_count']; ?></td>
                        <td><?php echo $submission['total_score']; ?></td>
                        <td>
                            <a href="student_answers.php?token_id=<?php echo $submission['id']; ?>" class="btn btn-primary btn-sm">Lihat Jawaban</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</body>
</html>