<?php
require_once '../includes/config.php';
require_once '../includes/auth.php';

if ($_SESSION['role'] !== 'teacher') {
    redirect('../index.php');
}

if (!isset($_GET['token_id'])) {
    redirect('dashboard.php');
}

$token_id = $_GET['token_id'];

// Get submission data
$stmt = $pdo->prepare("SELECT st.*, e.title as exam_title, e.subject, e.grade_level
                      FROM student_tokens st
                      JOIN exams e ON e.id = st.exam_id
                      WHERE st.id = ? AND e.teacher_id = ?");
$stmt->execute([$token_id, $_SESSION['user_id']]);
$submission = $stmt->fetch();

if (!$submission) {
    redirect('dashboard.php');
}

// Get exam questions
$stmt = $pdo->prepare("SELECT q.*, sa.answer, sa.score, sa.graded
                      FROM questions q
                      LEFT JOIN student_answers sa ON sa.question_id = q.id AND sa.token_id = ?
                      WHERE q.exam_id = ?
                      ORDER BY q.id");
$stmt->execute([$token_id, $submission['exam_id']]);
$questions = $stmt->fetchAll();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Process grading
    foreach ($_POST['scores'] as $question_id => $score) {
        $graded = isset($_POST['graded'][$question_id]) ? 1 : 0;
        $score = min($score, $_POST['max_scores'][$question_id]); // Ensure score doesn't exceed max
        
        $stmt = $pdo->prepare("UPDATE student_answers 
                              SET score = ?, graded = ?
                              WHERE question_id = ? AND token_id = ?");
        $stmt->execute([$score, $graded, $question_id, $token_id]);
    }
    
    $_SESSION['success'] = "Nilai berhasil disimpan!";
    header("Location: view_submission.php?token_id=$token_id");
    exit();
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Jawaban - Sistem Ujian SD</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <?php include '../includes/header.php'; ?>
    
    <div class="container">
        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success"><?php echo $_SESSION['success']; unset($_SESSION['success']); ?></div>
        <?php endif; ?>
        
        <h1>Detail Jawaban Siswa</h1>
        <h2><?php echo htmlspecialchars($submission['exam_title']); ?></h2>
        <p>Siswa: <strong><?php echo htmlspecialchars($submission['student_name']); ?></strong></p>
        <p>Mata Pelajaran: <?php echo htmlspecialchars($submission['subject']); ?> | Kelas: <?php echo htmlspecialchars($submission['grade_level']); ?></p>
        
        <form method="POST">
            <div class="submission-questions">
                <?php foreach ($questions as $index => $question): ?>
                <div class="submission-question">
                    <div class="question-header">
                        <h3>Pertanyaan #<?php echo $index + 1; ?></h3>
                        <div class="question-meta">
                            <span>Tipe: <?php echo $question['question_type'] == 'multiple_choice' ? 'Pilihan Ganda' : 'Essay'; ?></span>
                            <span>Nilai Maks: <?php echo $question['max_score']; ?></span>
                        </div>
                    </div>
                    
                    <div class="question-text">
                        <p><?php echo htmlspecialchars($question['question_text']); ?></p>
                    </div>
                    
                    <?php if ($question['question_type'] == 'multiple_choice'): ?>
                        <div class="question-options">
                            <?php 
                            $options = json_decode($question['options'], true);
                            $student_answer = isset($question['answer']) ? $options[$question['answer']] : '-';
                            $correct_answer = $options[$question['correct_answer']];
                            ?>
                            
                            <p><strong>Jawaban Siswa:</strong> <?php echo htmlspecialchars($student_answer); ?></p>
                            <p><strong>Jawaban Benar:</strong> <?php echo htmlspecialchars($correct_answer); ?></p>
                            
                            <?php if ($student_answer == $correct_answer): ?>
                                <p style="color: green;">Nilai: <?php echo $question['max_score']; ?> (Benar)</p>
                                <input type="hidden" name="scores[<?php echo $question['id']; ?>]" value="<?php echo $question['max_score']; ?>">
                                <input type="hidden" name="graded[<?php echo $question['id']; ?>]" value="1" checked>
                            <?php else: ?>
                                <p style="color: red;">Nilai: 0 (Salah)</p>
                                <input type="hidden" name="scores[<?php echo $question['id']; ?>]" value="0">
                                <input type="hidden" name="graded[<?php echo $question['id']; ?>]" value="1" checked>
                            <?php endif; ?>
                        </div>
                    <?php else: ?>
                        <div class="question-essay">
                            <p><strong>Jawaban Siswa:</strong></p>
                            <div class="essay-answer">
                                <?php echo nl2br(htmlspecialchars($question['answer'] ?? '- Tidak dijawab -')); ?>
                            </div>
                            
                            <div class="grading-section">
                                <label>Nilai (maks <?php echo $question['max_score']; ?>):</label>
                                <input type="number" name="scores[<?php echo $question['id']; ?>]" 
                                       value="<?php echo $question['score'] ?? 0; ?>" 
                                       min="0" max="<?php echo $question['max_score']; ?>" required>
                                       
                                <label>
                                    <input type="checkbox" name="graded[<?php echo $question['id']; ?>]" 
                                           <?php echo ($question['graded'] ?? false) ? 'checked' : ''; ?>>
                                    Sudah dinilai
                                </label>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <input type="hidden" name="max_scores[<?php echo $question['id']; ?>]" value="<?php echo $question['max_score']; ?>">
                </div>
                <?php endforeach; ?>
            </div>
            
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">Simpan Nilai</button>
                <a href="view_results.php?id=<?php echo $submission['exam_id']; ?>" class="btn btn-secondary">Kembali</a>
            </div>
        </form>
    </div>
</body>
</html>